<?php
ini_set('display_errors',0);
date_default_timezone_set('Asia/Tehran');

$TOKEN='8052423226:AAFqhQ22w_JpJirxZpDSUqDQj-OX5ShjzE8'; // ⛔️ پیشنهاد: توکن را ریجنریت کنید
$API="https://api.telegram.org/bot{$TOKEN}/";

$DB_HOST='localhost';
$DB_NAME='botgalaxy_chery_bot';
$DB_USER='botgalaxy_chery_bot';
$DB_PASS='CMQtK2ORWGTqVwzM'; // ⛔️ پیشنهاد: پسورد را عوض کنید


$ADMIN_ID = 152224778; // آیدی تلگرامی خودت برای دریافت خطا/هشدار


/* لاگ قطعی */
$DEBUG_LOG = '/tmp/tg_lock_cron.log';

/* ========= اتصال DB ========= */
try {
  $pdo = new PDO("mysql:host={$DB_HOST};dbname={$DB_NAME};charset=utf8mb4",
    $DB_USER, $DB_PASS, [PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION]);
} catch (Exception $e) { http_response_code(500); exit; }

/* ========= ابزارک‌ها ========= */
function logit($s){ global $DEBUG_LOG; @file_put_contents($DEBUG_LOG, date('c')." $s\n", FILE_APPEND); }

function req($method, $data){
  global $API;
  $ch = curl_init($API.$method);
  curl_setopt_array($ch, [
    CURLOPT_POST => true,
    CURLOPT_HTTPHEADER => ['Content-Type: application/json'],
    CURLOPT_POSTFIELDS => json_encode($data, JSON_UNESCAPED_UNICODE),
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_TIMEOUT => 15,
  ]);
  $raw = curl_exec($ch);
  $err = curl_error($ch);
  $code= curl_getinfo($ch, CURLINFO_HTTP_CODE);
  curl_close($ch);

  if ($raw === false) {
    logit("HTTP ERR $method curl: $err");
    return null;
  }
  $res = json_decode($raw, true);
  if (empty($res['ok'])) {
    logit("API $method FAIL http=$code payload=".json_encode($data, JSON_UNESCAPED_UNICODE)." resp=".$raw);
  } else {
    // برای دیباگ مطمئن: فقط رویدادهای کلیدی را لاگ کن
    if ($method === 'sendMessage' || $method === 'setChatPermissions') {
      logit("API $method OK");
    }
  }
  return $res;
}

function dmAdmin($text){
  global $ADMIN_ID;
  if(!$ADMIN_ID) return;
  req('sendMessage',[
    'chat_id'=>$ADMIN_ID,
    'text'=>$text,
    'parse_mode'=>'HTML',
    'link_preview_options'=>['is_disabled'=>true]
  ]);
}


/* ستون lock_is_on را در صورت نبودن اضافه کن */
function ensureStateColumn($pdo){
  $col = $pdo->query("SHOW COLUMNS FROM group_settings LIKE 'lock_is_on'")->fetch(PDO::FETCH_ASSOC);
  if(!$col){
    try{
      $pdo->exec("ALTER TABLE group_settings ADD COLUMN lock_is_on TINYINT(1) NULL DEFAULT NULL AFTER lock_end");
      logit("ALTER TABLE: lock_is_on added");
    }catch(Exception $e){
      logit("ALTER TABLE failed: ".$e->getMessage()." (fallback: فایل حالت)");
    }
  }
}

function getConfig($pdo){
  $r=$pdo->query("SELECT * FROM group_settings LIMIT 1")->fetch(PDO::FETCH_ASSOC);
  if(!$r){
    $pdo->exec("INSERT INTO group_settings (id) VALUES (1)");
    $r=$pdo->query("SELECT * FROM group_settings LIMIT 1")->fetch(PDO::FETCH_ASSOC);
  }
  return $r;
}

function deleteDueTempMessages($pdo){
  $rows=$pdo->query("SELECT id, chat_id, message_id FROM temp_messages WHERE delete_after <= NOW() ORDER BY id ASC LIMIT 50")->fetchAll(PDO::FETCH_ASSOC);
  if(!$rows) return;
  foreach($rows as $r){
    req('deleteMessage',['chat_id'=>(string)$r['chat_id'],'message_id'=>(int)$r['message_id']]);
    $q=$pdo->prepare("DELETE FROM temp_messages WHERE id=:id");
    $q->execute([':id'=>$r['id']]);
  }
}


function isLockedNow($start,$end){
  $tz=new DateTimeZone('Asia/Tehran');
  $now=new DateTime('now',$tz);
  $nn=(int)$now->format('Hi');
  $sn=(int)str_replace(':','',$start);
  $en=(int)str_replace(':','',$end);
  if($sn==$en) return false;
  if($sn<$en)  return ($nn>=$sn && $nn<$en);
  return !($nn>=$en && $nn<$sn); // عبور از نیمه‌شب
}

/* قفل/باز گروه */
function lockGroupPermissions($cfg){
  return req('setChatPermissions', [
    'chat_id'=>(string)$cfg['group_id'],
    'use_independent_chat_permissions'=>true,
    'permissions'=>[
      'can_send_messages'=>false,
      'can_send_audios'=>false,
      'can_send_documents'=>false,
      'can_send_photos'=>false,
      'can_send_videos'=>false,
      'can_send_video_notes'=>false,
      'can_send_voice_notes'=>false,
      'can_send_polls'=>false,
      'can_send_other_messages'=>false,
      'can_add_web_page_previews'=>false,
    ]
  ]);
}
function unlockGroupPermissions($cfg){
  return req('setChatPermissions', [
    'chat_id'=>(string)$cfg['group_id'],
    'use_independent_chat_permissions'=>true,
    'permissions'=>[
      'can_send_messages'=>true,
      'can_send_audios'=>true,
      'can_send_documents'=>true,
      'can_send_photos'=>true,
      'can_send_videos'=>true,
      'can_send_video_notes'=>true,
      'can_send_voice_notes'=>true,
      'can_send_polls'=>true,
      'can_send_other_messages'=>true,
      'can_add_web_page_previews'=>true,
    ]
  ]);
}

function getForumInfo($chat_id){
  $ci = req('getChat', ['chat_id'=>(string)$chat_id]);
  $is_forum = (!empty($ci['ok']) && !empty($ci['result']['is_forum']));
  return [$is_forum, $ci];
}


/* ارسال اعلان در تاپیک تعیین‌شده (یا 1 مثل کد خوش‌آمد) */
function sendAnnouncement($cfg, $text){
  $chatId = (string)$cfg['group_id'];
  list($is_forum, $ci) = getForumInfo($chatId);

  // سازندهٔ payload
  $make = function($threadId = null) use ($chatId, $text){
    $p = [
      'chat_id' => $chatId,
      'text' => $text,
      'parse_mode' => 'HTML',
      'link_preview_options' => ['is_disabled' => true],
      'allow_sending_without_reply' => true
    ];
    if ($threadId !== null) $p['message_thread_id'] = (int)$threadId;
    return $p;
  };

  // کمک‌تابع برای دیباگ کامل
  $reportFail = function($where, $payload, $resp) use ($cfg){
    $desc = is_array($resp) ? ($resp['description'] ?? 'no_description') : 'no_response';
    $raw  = is_array($resp) ? json_encode($resp, JSON_UNESCAPED_UNICODE) : 'null';
    dmAdmin(
      "❗️ارسال اعلان ناموفق @ <b>$where</b>\n".
      "chat_id=<code>{$cfg['group_id']}</code>\n".
      (isset($payload['message_thread_id']) ? "thread=<code>{$payload['message_thread_id']}</code>\n" : "").
      "desc=<code>".htmlspecialchars($desc,ENT_QUOTES,'UTF-8')."</code>\n".
      "resp=<code>".htmlspecialchars($raw,ENT_QUOTES,'UTF-8')."</code>"
    );
  };

  // اگر Forum نیست → بدون thread
  if (!$is_forum) {
    $p = $make(null);
    $r = req('sendMessage', $p);
    if (empty($r) || empty($r['ok'])) $reportFail('non-forum', $p, $r);
    return $r;
  }

  // Forum: 1) با announce_topic_id (اگر معتبر بود)
  $cfgThread = null;
  if (!empty($cfg['announce_topic_id']) && ctype_digit((string)$cfg['announce_topic_id']) && (int)$cfg['announce_topic_id']>0){
    $cfgThread = (int)$cfg['announce_topic_id'];
    $p = $make($cfgThread);
    $r = req('sendMessage', $p);
    if (!empty($r['ok'])) return $r;
    $reportFail('cfg_thread', $p, $r);
  }

  // Forum: 2) با تاپیک ۱ (General)
  if ($cfgThread !== 1) {
    $p2 = $make(1);
    $r2 = req('sendMessage', $p2);
    if (!empty($r2['ok'])) return $r2;
    $reportFail('general_1', $p2, $r2);
  }

  // Forum: 3) یک تلاش آخر بدون thread (برای اینکه خطای دقیق تلگرام را بگیریم)
  // (در گروه‌های Forum معمولاً این هم خطا می‌دهد، ولی description‌اش خیلی راهگشاست)
  $p3 = $make(null);
  $r3 = req('sendMessage', $p3);
  if (empty($r3) || empty($r3['ok'])) $reportFail('forum_no_thread_probe', $p3, $r3);
  return $r3;
}


/* ========= اجرا ========= */
ensureStateColumn($pdo);
$cfg = getConfig($pdo);


deleteDueTempMessages($pdo);

if (empty($cfg['group_id']) || empty($cfg['lock_start']) || empty($cfg['lock_end']) || !(int)$cfg['lock_enabled']) {
  logit("SKIP (config incomplete or disabled)");
  echo "OK"; exit;
}

$now   = new DateTime('now', new DateTimeZone('Asia/Tehran'));
$today = $now->format('Y-m-d');
$nowHM = $now->format('H:i');

$ls = trim($cfg['lock_start']);
$le = trim($cfg['lock_end']);

$shouldLock = isLockedNow($ls, $le);
$prevState  = array_key_exists('lock_is_on',$cfg) ? $cfg['lock_is_on'] : null; // null|0|1

logit("RUN now=$nowHM ls=$ls le=$le shouldLock=".($shouldLock?1:0)." prev=".($prevState===null?'NULL':(int)$prevState));

/* اگر بار اول است، فقط مقداردهی اولیه کنیم که اعلان الکی نرود */
if ($prevState === null) {
  $pdo->prepare("UPDATE group_settings SET lock_is_on=:v WHERE id=1")->execute([':v'=>$shouldLock?1:0]);
  logit("INIT state -> ".($shouldLock?1:0));
}

/* ترنزیشن: UNLOCK -> LOCK  (اعلان شروع) */
elseif (!$prevState && $shouldLock) {
  $txt = $cfg['announce_start_text']
       ?: "⏰ زمان فعال شدن قفل خودکار رسیده است !\n\n» ارسال پیام در گروه تا ساعت [ {END} ] ممنوع می‌باشد.";
  $txt = str_replace('{END}', $le, $txt);
  logit("TRANSITION: UNLOCK->LOCK (announce start)");
  $r = sendAnnouncement($cfg, $txt);
  $pdo->prepare("UPDATE group_settings SET lock_is_on=1, announce_start_sent=:d WHERE id=1")->execute([':d'=>$today]);
}

/* ترنزیشن: LOCK -> UNLOCK  (اعلان پایان) */
elseif ($prevState && !$shouldLock) {
  $txt = $cfg['announce_end_text']
       ?: "✅ زمان قفل خودکار به پایان رسید !\n\n» کاربران میتوانند پیام های خود را ارسال کنند.";
  logit("TRANSITION: LOCK->UNLOCK (announce end)");
  $r = sendAnnouncement($cfg, $txt);
  $pdo->prepare("UPDATE group_settings SET lock_is_on=0, announce_end_sent=:d WHERE id=1")->execute([':d'=>$today]);
}

/* اعمال وضعیت مطلوب هر بار (ایدامپوتنت) */
if ($shouldLock) {
  lockGroupPermissions($cfg);
} else {
  unlockGroupPermissions($cfg);
}

echo "OK";